# Gotchas:
# $xyx, $(xyz), ${xyz} and %xyx indicate variables to be replaced at runtime, please do NOT translate variable names
# & in button labels such as accessibility denotes the quick access letter
# buttons are fixed in length, so please make sure the translated strings will fit

# MAIN PAGE
LangString UseCD ${LANG_CATALAN} "(Use CD)"
LangString ReadOnly ${LANG_CATALAN} "(Read Only)"
LangString MainHeaderSubText ${LANG_CATALAN} "Selecciona nom d'usuari i clau d'accs per al nou compte, si us plau"
LangString MainLanguageLabel ${LANG_CATALAN} "Llengua:"
LangString MainUsernameLabel ${LANG_CATALAN} "Nom d'usuari"
LangString MainPasswordLabel ${LANG_CATALAN} "Clau d'accs:"
LangString MainInstallationSizeLabel ${LANG_CATALAN} "Mida d'installaci"
LangString MainDistroLabel ${LANG_CATALAN} "Desktop Environment:"
LangString MainInstallationDriveLabel ${LANG_CATALAN} "Installation Drive ($freeSpace GB free):"

# TOOLTIPS
LangString MainLanguageToolTip ${LANG_CATALAN} "Installation language."
LangString MainUsernameToolTip ${LANG_CATALAN} "Please select a username for the new account.$\r$\nIt must be lower case.$\r$\nIt must not contain spaces.$\r$\nIt must contain only standard letters and numbers.$\r$\nIt cannot start by a number."
LangString MainPasswordToolTip ${LANG_CATALAN} "Please select a password for the new account.$\r$\nIt must not contain spaces."
LangString MainInstallationSizeToolTip ${LANG_CATALAN} "How many GB do you want to allocate?$\r$\n4GB is the bare minimum$\r$\n8GB is comfortable"
LangString MainInstallationDriveToolTip ${LANG_CATALAN} "In which drive do you want to perform the installation?$\r$\nThis drive should have at least 5 GB free."
LangString Distro1ToolTip ${LANG_CATALAN} "Ubuntu is the default."
LangString Distro2ToolTip ${LANG_CATALAN} "Kubuntu uses the KDE3.5 desktop."
LangString Distro3ToolTip ${LANG_CATALAN} "Kubuntu-KDE4 uses the KDE4 desktop."
LangString Distro4ToolTip ${LANG_CATALAN} "Xubuntu is good for older systems."
LangString MainDistroToolTip ${LANG_CATALAN} "What graphical environment do you want to install?$\r$\n* $(Distro1ToolTip)$\r$\n* $(Distro2ToolTip)$\r$\n* $(Distro3ToolTip)$\r$\n* $(Distro4ToolTip)"

# ERRORS
LangString ErrorNoUsername ${LANG_CATALAN} "Please enter a valid username"
LangString ErrorSpaceInUsername ${LANG_CATALAN} "Please do not use spaces in the username."
LangString ErrorUsernameUpperCase ${LANG_CATALAN} "Please use all lower cases in the username."
LangString ErrorUsernameFirstCharNotLetter ${LANG_CATALAN} "Your username must start with a letter."
LangString ErrorUsernameIllegalChars ${LANG_CATALAN} "Your username must contain only standard letters and numbers."
LangString ErrorReservedUsername ${LANG_CATALAN} "The selected username is reserved, please selected a different one."
LangString ErrorNoPassword ${LANG_CATALAN} "Please enter a valid password."
LangString ErrorPasswordMismatch ${LANG_CATALAN} "Passwords do not match."
LangString ErrorSpaceInPassword ${LANG_CATALAN} "Please do not use spaces in the password."
LangString ErrorNoFreeSpace ${LANG_CATALAN} "Not enough free space."
LangString ErrorNoKernel ${LANG_CATALAN} "Could not retrieve some essential files"
LangString ErrorBcdedit ${LANG_CATALAN} "Error while trying to execute bcdedit:"
LangString ErrorWubibcd ${LANG_CATALAN} "Error while trying to execute wubibcd:"
LangString ErrorCD2ISO ${LANG_CATALAN} "Could not access the CD, please make sure other applications are not using it and try again"
LangString ErrorDownload ${LANG_CATALAN} "The download was interrupted with the error:"
LangString ErrorNoCD ${LANG_CATALAN} "Could not find any appropriate CD"
LangString ErrorNoAdmin ${LANG_CATALAN} "You must be logged in as administrator!"
LangString ErrorNoMemory ${LANG_CATALAN} "You need at least ${MinMemoryMB}MB of memory to run the installer!"

# INSTALLER
LangString AboutToInstall ${LANG_CATALAN} "You are about to install $Distro-$DistroVersion"
LangString InstallHeaderInitializing ${LANG_CATALAN} "Installing $Distro-$DistroVersion"
LangString InstallSubHeader ${LANG_CATALAN} "Please wait while the required files are retrieved and prepared"
LangString InstallHeaderUncompressWubifolder ${LANG_CATALAN} "Uncompressing wubi folder..."
LangString InstallHeaderCopyIso ${LANG_CATALAN} "Copying installation files..."
LangString InstallHeaderDownload ${LANG_CATALAN} "Retrieving installation files, resume supported"
LangString InstallHeaderBackupIso ${LANG_CATALAN} "Backing up installation files..."
LangString InstallHeaderWritePreseed ${LANG_CATALAN} "Writing configuration files..."
LangString InstallHeaderWriteUninstaller ${LANG_CATALAN} "Setting up uninstaller..."
LangString InstallHeaderWriteBootLoader ${LANG_CATALAN} "Setting up bootloader..."
LangString InstallGenerateVirtualDisks ${LANG_CATALAN} "Creating virtual disks..."
LangString InstallCopyFiles ${LANG_CATALAN} "Copying installation files..."
LangString InstallCreateFolders ${LANG_CATALAN} "Creating folders..."
LangString InstallRetrieveIso ${LANG_CATALAN} "Retrieving installation files."

# UNINSTALLER
LangString UninstallAlreadyInstalled ${LANG_CATALAN} "${AppName} is already installed"
LangString UninstallAsk ${LANG_CATALAN} "Do you want to uninstall it?"
LangString UninstallMessageField ${LANG_CATALAN} "$OldInstallationDrive\${DefaultInstallationDir} will be uninstalled.$\r$\nYou can backup your files if you want."
LangString UninstallBackupIsoCheckBox ${LANG_CATALAN} "Backup downloaded files (CD ISO file)."
LangString UninstallBackupHomeCheckBox ${LANG_CATALAN} "Backup personal documents (home.disk)."
LangString UninstallBackupLocationField ${LANG_CATALAN} "Backup location: $BackupFolder"

# FINISH
LangString EjectRebootMsg ${LANG_CATALAN} "Please remove any CD/DVD and reboot to complete the installation."
LangString RebootMsg ${LANG_CATALAN} "Necessites reiniciar per a completar la installaci."

# DOWNLOADER
LangString MetadlDownloading ${LANG_CATALAN} "Downloading installation files..."
LangString MetadlChecking ${LANG_CATALAN} "Checking installation files..."
LangString MetadlConnecting ${LANG_CATALAN} "Connecting to %s..."
LangString MetadlInitializing ${LANG_CATALAN} "Initializing..."
LangString MetadlChecksums ${LANG_CATALAN} "Calculating checksums..."
LangString MetadlRetrying1 ${LANG_CATALAN} "Retrying in %d seconds... (%d of %d)"
LangString MetadlRetrying2 ${LANG_CATALAN} "Retrying in %d seconds..."
LangString MetadlSecond ${LANG_CATALAN} "second"
LangString MetadlSeconds ${LANG_CATALAN} "seconds"
LangString MetadlProgress ${LANG_CATALAN} "%s (%d%%) of %s @ %s/s"
LangString MetadlRemaining ${LANG_CATALAN} " (%s remaining)"
LangString PleaseConnect ${LANG_CATALAN} "Please connect to the internet now."

# ACCESSIBILITY
LangString MobilityAids ${LANG_CATALAN} "Mobility Aids"
LangString VisibilityAids ${LANG_CATALAN} "Visibility Aids"
LangString AccessibilityButton ${LANG_CATALAN} "&Accessibility"
LangString AccessibilityText ${LANG_CATALAN} "Accessibility profile"
LangString AccessibilitySubText ${LANG_CATALAN} "Please select the appropriate accessibility profile"
LangString NoAccessibility ${LANG_CATALAN} "None"
LangString VisibilityHighContrast ${LANG_CATALAN} "High Contrast"
LangString VisibilityMagnifier ${LANG_CATALAN} "Magnifier"
LangString VisibilityScreenReader ${LANG_CATALAN} "Screen Reader"
LangString VisibilityBraille ${LANG_CATALAN} "Braille Terminal"
LangString MobilityKeyboardModifiers ${LANG_CATALAN} "Keyboard Modifiers"
LangString MobilityOnScreenKeyboard ${LANG_CATALAN} "On-Screen Keyboard"

# CDBOOT
LangString CDBootTitle ${LANG_CATALAN} "Install CD booter"
LangString CDBootText ${LANG_CATALAN} "If your machine cannot boot off the CD, this program will install a new boot menu entry to help you boot from CD. In most cases this program is not needed, and it is sufficient to reboot with the CD-Rom in the tray.$\r$\n$\r$\nDo you want to proceed and install the CD booter?"

# BOOTMENU
LangString BootMenuNormal ${LANG_CATALAN} "Start installer in normal mode"
LangString BootMenuSafeGraphics ${LANG_CATALAN} "Start installer in safe graphic mode (only if you have display problems)"
LangString BootMenuACPI ${LANG_CATALAN} "Start installer with ACPI workarounds (only if you have ACPI problems)"
LangString BootMenuVerbose ${LANG_CATALAN} "Start installer in verbose mode"

# FAILURE-COMMAND
LangString FailureCommand ${LANG_CATALAN} "The installation failed. Logs have been saved in: $INSTDIR\installation-logs.zip.$\r$\n$\r$\nNote that in verbose mode, the logs may include the password.$\r$\n$\r$\nThe system will now reboot."
